using System;
using System.Data;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Summary description for DlgSelectBloodUnits.
	/// </summary>
	public class DlgSelectBloodUnits : VbecsBaseForm
	{
		#region Variables
        //
        static private  string  MINCOLUMNLIST = "LabelUnitId,UnitProductCode,ProductTypeCode," +
            "ProductName,RhFactorCode,BloodTypeCode,AboRh,UnitInDate,UnitExpirationDate," +
            "UnitStatusCode,UnitStatusText,UnitDivisionId,FullProductCode,EyeReadableUnitId";
        //
//        private System.Data.DataTable _allTestedUnits; 
		private System.Data.DataTable _antigenTypes;
		private System.Data.DataTable _bloodUnitsInitial;
		private System.Data.DataTable _bloodUnitsSelected;
		private System.Data.DataTable _cmvNegUnits;
        private System.Data.DataTable _sickleNegUnits;
        //
        private int _maximumSelectedItems;
		private bool _multiSelect;
		//
		private BOL.UnitFilter _unitFilter;
		private bool _isLoading;

		//When DeSelectAll buttons are clicked, it looks through and unchecks items in the listviews
		//This unchecking, fires the click event, which could potentially cause the LoadUnits() method to 
		//be fired multiple times per DeSelectAll_Click(), since the LoadUnits() method is inside all of the lv_ItemCheck() events
		private bool _isDeselectAll = false;

		//Adding these in here to avoid differences in display/filter checking -- consistancy people!
		private const string _POS = "Pos";
		private const string _NEG = "Neg";

		#endregion

		#region Form Controls
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnClearAntigens;
        //
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.CheckBox cbCMVNeg;
		private System.Windows.Forms.CheckBox cbExpAfter;
		private System.Windows.Forms.CheckBox cbExpBefore;
		private System.Windows.Forms.CheckBox cbRcvdAfter;
		private System.Windows.Forms.CheckBox cbRcvdBefore;
		private System.Windows.Forms.CheckBox cbSickleCellScreen;
		private System.Windows.Forms.ColumnHeader colABORh;
		private System.Windows.Forms.ColumnHeader colCheckBox;
		private System.Windows.Forms.ColumnHeader colDateTimeReceived;
		private System.Windows.Forms.ColumnHeader colDonation;
		private System.Windows.Forms.ColumnHeader colExpire;
		private System.Windows.Forms.ColumnHeader colProduct;
		private System.Windows.Forms.ColumnHeader colStatus;
        private ColumnHeader colRestrictedFor;
		//
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader colUnitID;

		private System.ComponentModel.IContainer components;

		private System.Windows.Forms.DateTimePicker dtpExpAfter;
		private System.Windows.Forms.DateTimePicker dtpExpBefore;
		private System.Windows.Forms.DateTimePicker dtpRcvdAfter;
		private System.Windows.Forms.DateTimePicker dtpRcvdBefore;

		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.GroupBox grpABORh;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpProductType;
		private System.Windows.Forms.GroupBox grpSearch;
		private System.Windows.Forms.GroupBox grpSelectedUnits;
		private System.Windows.Forms.GroupBox grpSpecial;

		private System.Windows.Forms.Label lblRBCAntigen;

		private System.Windows.Forms.ListView lstAntigens;
		private System.Windows.Forms.ListView lvABORh;
		private System.Windows.Forms.ListView lvProductType;
		private System.Windows.Forms.ListView lvSelectedUnitsCheckboxes;
        //
		private System.Windows.Forms.PictureBox pictureBox1;

		private System.Windows.Forms.Panel pnlRight;

		private System.Windows.Forms.Timer timer1;

		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Button btnClearProducts;
		private System.Windows.Forms.Button btnClearABORh;
		private System.Windows.Forms.ColumnHeader colCode;
       

		private System.Windows.Forms.TextBox txtAntigen;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Instantiate a Select units Dialog with an initial table of units to be scanned.
		/// </summary>
		/// <param name="initialUnitDataTable">DataTable containing list of units to be searched.</param>
        ///	<param name="eyeReadableUnitId">EyeReadable to limit the dislay of possible units</param>
        ///	<param name="productCode">Productcode to limit to the display the possible units</param>
		public DlgSelectBloodUnits(System.Data.DataTable initialUnitDataTable, string eyeReadableUnitId, string productCode)
        {
			this._isLoading = true;
         
			InitializeComponent();
            //
            SetComponentProperties();
			
			// The UnitFilter class automatically does some sorting.  The boolean will stop it.. Should just cleanup UnitFilter?
			_unitFilter = new BOL.UnitFilter(false);

			//BR_4.01 -----------------
			string strSQL = string.Empty;

			if (eyeReadableUnitId != string.Empty)
				strSQL = TABLE.BloodUnit.EyeReadableUnitId + " NOT LIKE '" + eyeReadableUnitId + "%'";
			if (productCode != string.Empty)
			{
				if (strSQL != string.Empty)
					strSQL += " OR ";

				
				strSQL += ARTIFICIAL.FullProductCode +  " NOT LIKE '" + productCode + "%'";
			}

			if (strSQL != string.Empty)
			{
				System.Data.DataRow[] dRows = initialUnitDataTable.Select(strSQL);

				foreach (DataRow dr in dRows)
				{
					initialUnitDataTable.Rows.Remove(dr);
				}
			}

            this.SourceUnitTable = initialUnitDataTable;

            VbecsFunction.SetColumnWidths(lvSelectedUnitsCheckboxes);

            _maximumSelectedItems = -1;
            _multiSelect = true;

			this._isLoading = false;
        }


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Events/Event Handlers
		/// <summary>
		/// User wants to clear the antigens selection criteria.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClearAntigens_Click(object sender, System.EventArgs e)
		{
			this._isDeselectAll = true;

			this.cbCMVNeg.Checked = false;
			this.cbSickleCellScreen.Checked = false;
			//
			foreach(ListViewItem lvi in lstAntigens.CheckedItems)
			{
				lvi.Checked = false;
			}

			this._isDeselectAll = false;
			this.LoadUnits();
		}

		//
		/// <summary>
		/// Return to caller of this Dialog.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			return;
		}

		//
		/// <summary>
		/// User has selected only CMV negative units.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbCMVNeg_CheckedChanged(object sender, System.EventArgs e)
		{
			foreach (DataRow dr in _cmvNegUnits.Rows)
			{
				System.Guid bloodUnitGuid = ((System.Guid)dr[TABLE.BloodUnit.BloodUnitGuid]);
				if (cbCMVNeg.Checked)
				{
					_unitFilter.AddCMVToFilter(bloodUnitGuid);
				}
				else
				{
					_unitFilter.RemoveCMVFromFilter(bloodUnitGuid);
				}
			}
			LoadUnits();
		}

		//
		/// <summary>
		/// User is searching for units expiring after the date indicated.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbExpAfter_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbExpAfter.Checked)
			{
				this.dtpExpAfter.Enabled = true;
				this.dtpExpAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpExpAfter.Enabled = false;
				this.dtpExpAfter.CustomFormat = " ";
			}
			//
			ExpAfterDateChange();
		}

		//
		/// <summary>
		/// User is searching for units expiring before the date indicated.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbExpBefore_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbExpBefore.Checked)
			{
				this.dtpExpBefore.Enabled = true;
				this.dtpExpBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpExpBefore.Enabled = false;
				this.dtpExpBefore.CustomFormat = " ";
			}
			//
			ExpBeforeDateChange();
		}

		//
		/// <summary>
		/// User is searching for units received after the date indicated.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbRcvdAfter_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbRcvdAfter.Checked)
			{
				this.dtpRcvdAfter.Enabled = true;
				this.dtpRcvdAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpRcvdAfter.Enabled = false;
				this.dtpRcvdAfter.CustomFormat = " ";
			}
			//
			RcvdAfterDateChange();
		}

		//
		/// <summary>
		/// User is searching for units received before the date indicated.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbRcvdBefore_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbRcvdBefore.Checked)
			{
				this.dtpRcvdBefore.Enabled = true;
				this.dtpRcvdBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpRcvdBefore.Enabled = false;
				this.dtpRcvdBefore.CustomFormat = " ";
			}
			//
			RcvdBeforeDateChange();
		}

		//
		/// <summary>
		/// User has selected only sickle cell negative units.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbSickleCellScreen_CheckedChanged(object sender, System.EventArgs e)
		{
			foreach (DataRow dr in _sickleNegUnits.Rows)
			{
				System.Guid bloodUnitGuid = ((System.Guid)dr[TABLE.BloodUnit.BloodUnitGuid]);
				if (cbSickleCellScreen.Checked)
				{
					_unitFilter.AddSickleCellToFilter(bloodUnitGuid);
				}
				else
				{
					_unitFilter.RemoveSickleCellFromFilter(bloodUnitGuid);
				}
			}
			LoadUnits();
		}

		//
		/// <summary>
		/// Initialize and populate the Selection lists.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectBloodUnits_Load(object sender, System.EventArgs e)
		{
			_cmvNegUnits = BOL.BloodUnitTest.GetCmvNegativeUnitsForDivision( Common.LogonUser.LogonUserDivisionCode );

			if (_cmvNegUnits.Rows.Count == 0)
			{
				DataRow dr = _cmvNegUnits.NewRow();
				
				dr[TABLE.BloodUnit.BloodUnitGuid]		= Guid.Empty;
				dr[TABLE.BloodTestType.BloodTestTypeId]	= 0;
				dr[TABLE.BloodTestType.BloodTestName]		= string.Empty;
				dr[TABLE.TestResult.TestResultText]	= string.Empty;
				dr[TABLE.TestResult.TestResultId]		= string.Empty;
				dr[TABLE.BloodUnit.DivisionCode]		= string.Empty;	
				
				_cmvNegUnits.Rows.Add(dr);
			}

			_sickleNegUnits =  BOL.BloodUnitTest.GetSickleCellNegativeUnitsForDivision( Common.LogonUser.LogonUserDivisionCode );
			if (_sickleNegUnits.Rows.Count == 0)
			{
				DataRow dr = _sickleNegUnits.NewRow();

				dr[TABLE.BloodUnit.BloodUnitGuid] = Guid.Empty;
				dr[TABLE.BloodTestType.BloodTestTypeId]	= 0;
				dr[TABLE.BloodTestType.BloodTestName]		= string.Empty;
				dr[TABLE.TestResult.TestResultText]	= string.Empty;
				dr[TABLE.TestResult.TestResultId]		= string.Empty;
				dr[TABLE.BloodUnit.DivisionCode]		= string.Empty;	

				_sickleNegUnits.Rows.Add(dr);
			}

//This was never being used, commented out - 4/24/2005 by McHugh's cubemate.
//			_allTestedUnits = BOL.BloodUnitTest.GetAllUnitTestsForDivision( Common.LogonUser.LogonUserDivisionCode );
			LoadAntigens();
			LoadAboRHValues();
		}

		/// <summary>
		/// User has changed the expires after date value.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpExpAfter_ValueChanged(object sender, System.EventArgs e)
		{
			ExpAfterDateChange();
		}

		//
		/// <summary>
		/// User has changed the expires before date value.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpExpBefore_ValueChanged(object sender, System.EventArgs e)
		{
			ExpBeforeDateChange();
		}

		//

		/// <summary>
		/// User has changed the date value for the received after search.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpRcvdAfter_ValueChanged(object sender, System.EventArgs e)
		{
			RcvdAfterDateChange();
		}

		//
		/// <summary>
		/// User is searching for units received before the date indicated.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpRcvdBefore_ValueChanged(object sender, System.EventArgs e)
		{
			RcvdBeforeDateChange();
		}
	
		//
		/// <summary>
		/// User has checked an Antigen item
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lstAntigens_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{

			ListViewItem lvi = lstAntigens.Items[e.Index];
			System.Guid filterGuid =  System.Guid.Empty;
			txtAntigen.Text = string.Empty;
			DataRow drT = (DataRow)lvi.Tag;
			DataTable dtAntibodys = BOL.AntibodyType.GetBloodUnitsWithAntibodyType((int)drT[TABLE.AntibodyType.AntibodyTypeId]);
			// Non-matching value??
			if (e.NewValue == CheckState.Checked) 
			{

				_unitFilter.AddSpecialTestingToFilter(filterGuid);
			}
			else
			{
				_unitFilter.RemoveSpecialTestingFromFilter(filterGuid);
			}
			//
			foreach(DataRow dr in dtAntibodys.Rows)
			{
				filterGuid = System.Guid.Empty;
				if ((bool)dr[TABLE.BloodUnitAntigen.Positive])
				{
					if ( lvi.SubItems[1].Text.IndexOf(_POS) > 0 )
					{
						filterGuid = ((System.Guid)dr[TABLE.BloodUnit.BloodUnitGuid]);
					}
				}
				else
				{
					if ( lvi.SubItems[1].Text.IndexOf(_NEG) > 0 )
					{
						filterGuid = ((System.Guid)dr[TABLE.BloodUnit.BloodUnitGuid]);
					}
				}
				if ( filterGuid != System.Guid.Empty)
				{
					if (e.NewValue == CheckState.Checked) 
					{

						_unitFilter.AddSpecialTestingToFilter(filterGuid);
					}
					else
					{
						_unitFilter.RemoveSpecialTestingFromFilter(filterGuid);
					}
				}
			}
		
			this.LoadUnits();
		}

		//
		//
		//
		/// <summary>
		/// User has checked ABO/Rh criterion
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvABORh_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			string aboRh;
			int eIndex = e.Index;
			ListViewItem lvi = lvABORh.Items[e.Index];
			aboRh = lvABORh.Items[e.Index].SubItems[1].Text;
			if (e.NewValue == CheckState.Checked) 
			{
				_unitFilter.AddAboRhToFilter(aboRh);
			}
			else
			{
				_unitFilter.RemoveAboRhFromFilter(aboRh);
			}

			LoadUnits();
		}

		//
		/// <summary>
		/// User has checked a product type to filter.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvProductType_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			string productTypeCode;
			ListViewItem lvi = lvProductType.Items[e.Index];
			if (e.NewValue == CheckState.Checked) 
			{
				int eIndex = e.Index;
				productTypeCode = lvi.SubItems[2].Text;
				_unitFilter.AddProductTypeCodeToFilter(productTypeCode);
			}
			else
			{
				productTypeCode = productTypeCode = lvi.SubItems[2].Text;
				_unitFilter.RemoveProductTypeCodeFromFilter(productTypeCode);
			}

			LoadUnits();
		}

		//
		/// <summary>
		/// User has clicked on a column header, sort by that column.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnitsCheckboxes_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == this.lvSelectedUnitsCheckboxes.Columns.IndexOf(this.colExpire) || e.Column == this.lvSelectedUnitsCheckboxes.Columns.IndexOf(this.colDateTimeReceived))
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvSelectedUnitsCheckboxes.CheckBoxes, ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvSelectedUnitsCheckboxes.CheckBoxes, ColumnClickSorter.ColumnSortType.String);
			}
		}

		//
		/// <summary>
		/// User has selected a Unit item to process and hand off. Add it to the selected units table.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSelectedUnitsCheckboxes_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			DataRow dr = _bloodUnitsSelected.NewRow();
			if (e.NewValue==CheckState.Checked)
			{
				if (!this._multiSelect)
				{
					//Uncheck existing rows first
					foreach(ListViewItem lvi in this.lvSelectedUnitsCheckboxes.CheckedItems)
					{
						lvi.Checked = false;
					}
				}
				//
				dr.ItemArray =((DataRow)lvSelectedUnitsCheckboxes.Items[e.Index].Tag).ItemArray;
				if (_bloodUnitsSelected.Rows.Find(dr[TABLE.BloodUnit.BloodUnitGuid]) == null) 
				{
					_bloodUnitsSelected.Rows.Add(dr);
				}
			}
			else
			{
				DataRow rmDr = _bloodUnitsSelected.Rows.Find(((DataRow)lvSelectedUnitsCheckboxes.Items[e.Index].Tag)[TABLE.BloodUnit.BloodUnitGuid]);
				if (rmDr != null) 
				{
					_bloodUnitsSelected.Rows.Remove(rmDr);
				}
			}
			btnOK.EnabledButton = _bloodUnitsSelected.Rows.Count > 0;
			if ( btnOK.EnabledButton )
			{
				btnOK.SetToolTip(string.Empty);
			}
			else
			{
				btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectUnit().ResString);
			}

		}

		//
		/// <summary>
		/// User is searching for a specific antigen type in the listbox,
		/// locate and bring it to fore.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtAntigen_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			string actual;
			//
			if ((e.KeyCode == Keys.Back) ||
				(e.KeyCode == Keys.Left) ||
				(e.KeyCode == Keys.Right) ||
				(e.KeyCode == Keys.Up) ||
				(e.KeyCode == Keys.Down) ||
				(e.KeyCode == Keys.Delete) ||
				(e.KeyCode == Keys.PageUp) ||
				(e.KeyCode == Keys.PageDown) ||
				(e.KeyCode == Keys.Home) ||
				(e.KeyCode == Keys.End))
			{
				return;
			}
			//
			actual = this.txtAntigen.Text;
			foreach(ListViewItem lviAntigen in lstAntigens.Items)
			{
				if (lviAntigen.SubItems[1].Text.StartsWith(actual))
				{
					lviAntigen.Selected = true;
					lviAntigen.EnsureVisible();
					break;
				}
			}

		}
		#endregion

		#region Methods

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		/// <summary>
		/// Will highlight the row(s) of inactive blood units
		/// Implements BR_85.01
		/// </summary>
		public void HighlightInactiveBloodUnits()
		{
			foreach (DataRow dr in this._bloodUnitsInitial.Rows)
			{
				if(dr[TABLE.BloodUnit.RecordStatusCode].ToString().Equals
					(Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive).ToString()))
				{
					ListViewItem lvi = FindBloodUnitInListView(lvSelectedUnitsCheckboxes.Items, (System.Guid)dr[TABLE.BloodUnit.BloodUnitGuid]);
					lvi.BackColor = SystemColors.WindowText;
					lvi.ForeColor = Color.WhiteSmoke;
				}
			}
		}

		//
		/// <summary>
		/// Add the expires after date to the filter criteria.
		/// </summary>
		private void ExpAfterDateChange()
		{
			if (!this._isLoading)
			{		
				System.DateTime afterExpDate = this.dtpExpAfter.Value.AddDays(1);
				if (cbExpAfter.Checked )
				{
					
					//10/1/2004 - Lohse - Adding AddDays(1) for CR211
					//Since UnitExpirationDate stores time & date
					//SQL brings back all dates greater than the wanted date including the same date
					//since 10/01/2004  00:01 > 10/01/2004.   SO, we set the date value ahead 1 day
					_unitFilter.AddExpirationAfterDateToFilter(afterExpDate);
				}
				else
				{
					//It's just clearing it.
					_unitFilter.RemoveExpirationAfterDateFromFilter(afterExpDate);
				}
				LoadUnits();
			}
		}

		//
		/// <summary>
		/// Add the expires before date to the filter criteria
		/// </summary>
		private void ExpBeforeDateChange()
		{
			if (!this._isLoading)
			{
				if (cbExpBefore.Checked )
				{
					_unitFilter.AddExpirationBeforeDateToFilter(dtpExpBefore.Value);
				}
				else
				{
					//It's just clearing it, don't really need the arg.
					_unitFilter.RemoveExpirationBeforeDateFromFilter(dtpExpBefore.Value);
				}
				LoadUnits();
			}
		}

		//
		/// <summary>
		/// Find a BloodUnit by Guid within the ListView tags,
		/// which contain the DataRow for the unit
		/// </summary>
		/// <param name="lvc">ListViewCollection to be searched.</param>
		/// <param name="bloodUnitGuid">The Guid to search for.</param>
		/// <returns></returns>
		private ListViewItem FindBloodUnitInListView(ListView.ListViewItemCollection lvc, System.Guid bloodUnitGuid)
		{
			IEnumerator selIter = lvc.GetEnumerator();
			while(selIter.MoveNext())
			{
				DataRow ldr = (DataRow)((ListViewItem)selIter.Current).Tag;
				if (bloodUnitGuid.CompareTo((System.Guid)ldr[TABLE.BloodUnit.BloodUnitGuid]) == 0)
				{
					return (ListViewItem)selIter.Current;
				}
			}
			return null;
		}

		/// <summary>
		/// Populate the Antigens selection list.
		/// </summary>
		private void LoadAntigens()
		{
            //
            int maxl = 0;
			//
			lstAntigens.Items.Clear();
			if (_antigenTypes == null) 
			{
				_antigenTypes = BOL.AntibodyType.GetAntibodyTypeLookupList();
			}

			ArrayList alAntigens = new ArrayList();
			foreach (DataRow dr in _antigenTypes.Rows)
			{
				try 
				{
					if ((dr[TABLE.AntigenType.AntigenTypeName].ToString().Length > 0) && (dr[TABLE.AntigenType.AntigenTypeName].ToString().ToUpper() != "NONE"))
					{
                        string antigenName = dr[TABLE.AntigenType.AntigenTypeName].ToString();
                        
						if (!alAntigens.Contains(antigenName))
						{
							maxl = System.Math.Max(maxl,antigenName.Length + 4);
							//
							ListViewItem lviNeg = new ListViewItem();
							lviNeg.SubItems.Add(antigenName + " " + _NEG);
							lviNeg.Tag = dr;
							lstAntigens.Items.Add(lviNeg);
							//
							ListViewItem lviPos = new ListViewItem();
							lviPos.SubItems.Add(antigenName + " " + _POS);
							lviPos.Tag = dr;
							lstAntigens.Items.Add(lviPos);

							alAntigens.Add(antigenName);
						}
					}
				}
				catch(Exception ex) 
				{
					ExceptionManagement.ExceptionManager.Publish(ex);
				}
			}
            txtAntigen.MaxLength = maxl;
		}

		//
		/// <summary>
		/// Populate the Product types selection list from the SourceDataTable
		/// </summary>
		private void LoadProductTypes()
		{
			lvProductType.Items.Clear();
			try 
			{
				if (_bloodUnitsInitial == null)
				{
					return;
				}
				//
				Hashtable ht = new Hashtable();
				foreach (DataRow dr in _bloodUnitsInitial.Rows) 
				{
					if ( !ht.ContainsKey(dr[TABLE.BloodProduct.ProductTypeCode].ToString()) )
					{
						if (_bloodUnitsInitial.Columns.Contains(TABLE.ProductType.ProductTypeName))
						{
							ht.Add(dr[TABLE.BloodProduct.ProductTypeCode].ToString(),dr[TABLE.ProductType.ProductTypeName].ToString());
						}
						else
						{
							DataRow drProduct = BOL.ReferenceData.GetProductType(dr[TABLE.BloodProduct.ProductTypeCode].ToString());
							ht.Add(drProduct[TABLE.BloodProduct.ProductTypeCode].ToString(),drProduct[TABLE.ProductType.ProductTypeName].ToString());
						}
					}
				}
				foreach(DictionaryEntry hash in ht)
				{
					ListViewItem lvi = new ListViewItem();
					lvi.Text = string.Empty;
					lvi.SubItems.Add(hash.Value.ToString());
					lvi.SubItems.Add(hash.Key.ToString());
					lvProductType.Items.Add(lvi); 					
				}
				VbecsFunction.SetColumnWidths(lvProductType);
			}
			catch (Exception ex) 
			{
				ExceptionManagement.ExceptionManager.Publish(ex);
			}
			finally
			{
			}
		}

		private void SortDataTable(ref System.Data.DataTable dtNew, DataTable dtAboRH, string sortItem)
		{
			foreach(System.Data.DataRow drNewRow in dtAboRH.Rows)
			{
				string sItem  = drNewRow[ARTIFICIAL.BloodTypeRhFactor].ToString().Replace("Mx", "Pooled");
				if(sItem.Trim() == sortItem.Trim())
				{
					System.Data.DataRow newRow = dtNew.NewRow();
					newRow.ItemArray = drNewRow.ItemArray;
					dtNew.Rows.Add(newRow);
					break;
				}
			}		
		}

		/// <summary>
		/// LoadAboRHValues
		/// </summary>
		public void LoadAboRHValues()
		{
			this.lvABORh.Items.Clear();
			//
			try 
			{

				DataTable dtAboRH = BOL.AboRh.GetAllAboRH();

				System.Data.DataTable dtNew = dtAboRH.Clone();

				SortDataTable(ref dtNew, dtAboRH, "O Pos");
				SortDataTable(ref dtNew, dtAboRH, "A Pos");
				SortDataTable(ref dtNew, dtAboRH, "B Pos");
				SortDataTable(ref dtNew, dtAboRH, "AB Pos");
				SortDataTable(ref dtNew, dtAboRH, "O Neg");
				SortDataTable(ref dtNew, dtAboRH, "A Neg");
				SortDataTable(ref dtNew, dtAboRH, "B Neg");
				SortDataTable(ref dtNew, dtAboRH, "AB Neg");
				SortDataTable(ref dtNew, dtAboRH, "O");
				SortDataTable(ref dtNew, dtAboRH, "A");
				SortDataTable(ref dtNew, dtAboRH, "B");
				SortDataTable(ref dtNew, dtAboRH, "AB");
				SortDataTable(ref dtNew, dtAboRH, "Pooled Pos");
				SortDataTable(ref dtNew, dtAboRH, "Pooled Neg");
				SortDataTable(ref dtNew, dtAboRH, "O Pooled");
				SortDataTable(ref dtNew, dtAboRH, "A Pooled");
				SortDataTable(ref dtNew, dtAboRH, "B Pooled");
				SortDataTable(ref dtNew, dtAboRH, "AB Pooled");
				SortDataTable(ref dtNew, dtAboRH, "Pooled Pooled");

				foreach(DataRow dr in dtNew.Rows)
				{
					string sItem  = dr[ARTIFICIAL.BloodTypeRhFactor].ToString().Replace("Mx", "Pooled");
					if(sItem != string.Empty)
					{
						ListViewItem lvi = new ListViewItem();
						lvi.SubItems.Add(sItem);
						lvi.Tag = dr;
						this.lvABORh.Items.Add(lvi);
					}
				}

				VbecsFunction.SetColumnWidths(lvProductType);
			}
			catch (Exception ex) 
			{
				ExceptionManagement.ExceptionManager.Publish(ex);
			}
			finally
			{
			}
		}

		/// <summary>
		/// Add the filtered Units and selected Units to the ListView
		/// </summary>
		private void LoadUnits()
		{
			using (new WaitCursor())
			{
				//We don't want the grid redrawn for every option uncheck when DeSelectAll is clicked.
				if (this._isDeselectAll) return;

				try
				{
					lvSelectedUnitsCheckboxes.Items.Clear();
					DataView filteredUnits = _unitFilter.FilteredUnitsView;
					//
					IEnumerator iter = filteredUnits.GetEnumerator();
					while(iter.MoveNext())
					{
						lvSelectedUnitsCheckboxes.Items.Add(MakeListViewItemFromRow(((DataRowView)iter.Current).Row)); 					
					}
					if (_bloodUnitsSelected == null) 
					{
						_bloodUnitsSelected = _bloodUnitsInitial.Clone();
						DataColumn[] dcP =  {_bloodUnitsSelected.Columns[TABLE.BloodUnit.BloodUnitGuid]};
						_bloodUnitsSelected.PrimaryKey = dcP;
						_unitFilter.SelectedUnits = _bloodUnitsSelected;
					}
					else
					{
						// "Check" each unit in selected units.
						foreach (DataRow busRow in _bloodUnitsSelected.Rows) 
						{
							ListViewItem lvi = FindBloodUnitInListView(lvSelectedUnitsCheckboxes.Items,(System.Guid)busRow[TABLE.BloodUnit.BloodUnitGuid]);
							if (lvi == null)
							{
								lvi = MakeListViewItemFromRow(busRow);
								lvi.Checked = true;
								lvSelectedUnitsCheckboxes.Items.Insert(0,lvi);
							}
							else
							{
								lvi.Checked = true;
							}
						}
					}
					// Set column width to the longest items
					VbecsFunction.SetColumnWidths(lvSelectedUnitsCheckboxes);

					this.grpSelectedUnits.Text = "Units within Criteria : " + lvSelectedUnitsCheckboxes.Items.Count.ToString();
				}
				catch(Exception e)
				{
					this.grpSelectedUnits.Text = "Units within Criteria";
					ExceptionManagement.ExceptionManager.Publish(e);
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InternalErrorUnrecognizedException(e.Message));
#if DEBUG
					throw e;
#endif
				}
			}
		}

		//
		/// <summary>
		/// Return a ListViewItem from a DataRow argument.
		/// </summary>
		/// <param name="dr">BloodUnit DataRow</param>
		/// <returns>ListView item to be added</returns>
		private ListViewItem MakeListViewItemFromRow(DataRow dr)
		{
			//BR_5.02
			ListViewItem lvi = new ListViewItem();
			lvi.Text = string.Empty; 
			lvi.SubItems.Add(dr[TABLE.BloodUnit.EyeReadableUnitId].ToString());
			lvi.SubItems.Add(dr[TABLE.BloodProduct.ProductShortName].ToString());
			//lvi.SubItems.Add(dr[TABLE.BloodUnit.UnitProductCode].ToString());
			//Lohse is probably going to get into a lot of trouble with this here, but it's a SME need to see the whole productcode (for ISBT)
			lvi.SubItems.Add(dr[ARTIFICIAL.FullProductCode].ToString());
			lvi.SubItems.Add(dr[ARTIFICIAL.ABORh].ToString().Replace("Mx","Pooled"));
			lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(dr[TABLE.BloodUnitMedia.UnitExpirationDate]));
			lvi.SubItems.Add(dr[TABLE.DonationType.DonationTypeText].ToString());
			//
			string status = dr[TABLE.UnitStatus.UnitStatusText].ToString();
			if ((bool)dr[TABLE.BloodUnitStatus.QuarantineIndicator])
			{
				status = status + " (Quarantined)";
			}
			if (!dr.IsNull(TABLE.BloodUnitStatus.PresumedTransfusedIndicator))
			{
				if ((bool)dr[TABLE.BloodUnitStatus.PresumedTransfusedIndicator])
				{
					status = "Presumed "+status;
				}
			}
			//03-15-2005 - Lohse, adding the following IF to Populate Status with BIOHARDARDOUS indicator
			if ((bool)dr[TABLE.BloodUnitStatus.BiohazardousWarningIndicator])
			{
				status = status + " (Biohazardous)";
			}			
			lvi.SubItems.Add(status);
			//
			//Changing from UnitInDate to ShipmentDate (CR 178)
			string unitInDate;
			if (dr.IsNull(TABLE.Shipment.ShipmentDate)) 
			{
				unitInDate = string.Empty;//Common.VBECSDateTime.FormatDateString(DateTime.MinValue); 
			}
			else 
			{
				unitInDate = Common.VBECSDateTime.FormatDateTimeString(dr[TABLE.Shipment.ShipmentDate]);
			}
            //Defect 251360
            string restrictedFor;
            if (dr.IsNull(TABLE.Patient.PatientLastName))
            {
                restrictedFor = string.Empty;
            }
            else
            {
                restrictedFor = (string)dr[TABLE.Patient.PatientLastName];
            }
            if (!dr.IsNull(TABLE.Patient.PatientFirstName))
            {
                if (!dr.IsNull(TABLE.Patient.PatientMiddleName))
                {
                    restrictedFor = restrictedFor + ", " +
                                    (string) dr[TABLE.Patient.PatientFirstName] + " " +
                                    (string) dr[TABLE.Patient.PatientMiddleName];
                }
                else
                {
                    restrictedFor = restrictedFor + ", " + (string)dr[TABLE.Patient.PatientFirstName];
                }
            }
            lvi.SubItems.Add(restrictedFor);


			lvi.SubItems.Add(unitInDate);
			//
			lvi.Tag = dr;
			return lvi;
		}


		//
		/// <summary>
		/// Add the received after date to the selection criteria
		/// </summary>
		private void RcvdAfterDateChange()
		{
			if (!this._isLoading)
			{
				System.DateTime afterRcvdDate = this.dtpRcvdAfter.Value.AddDays(1);

				if (cbRcvdAfter.Checked )
				{
					//10/1/2004 - Lohse - Adding AddDays(1) for CR211
					//Since UnitInDate stores time & date
					//SQL brings back all dates greater than the wanted date including the same date
					//since 10/01/2004  00:01 > 10/01/2004.   SO, we set the date value ahead 1 day
					_unitFilter.AddReceivedAfterDateToFilter(afterRcvdDate);
				}
				else
				{
					//It's just clearing it.
					_unitFilter.RemoveReceivedAfterDateFromFilter(afterRcvdDate);
				}
				LoadUnits();
			}
		}

		//
		/// <summary>
		/// Add the received before date to the unit filter criteria.
		/// </summary>
		private void RcvdBeforeDateChange()
		{
			if (!this._isLoading)
			{
				if (cbRcvdBefore.Checked )
				{
					_unitFilter.AddReceivedBeforeDateToFilter(dtpRcvdBefore.Value);
				}
				else
				{
					//It's just clearing it.
					_unitFilter.RemoveReceivedBeforeDateFromFilter(dtpRcvdBefore.Value);
				}
				LoadUnits();
			}
		}


		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/20/2002</CreationDate>
		///
		/// <summary>
		/// Allow or disallow multiple items to be selected.
		/// </summary>
		//        public bool SelectMulti
		//        {
		//            get 
		//            {
		//				//Removed. This setting does not affect checkboxes!
		//                //Replaced. That's not what it's for. And yes it can.
		//                // use MultiSelect instead.
		//				PEOPLE PLEASE!!!  YOU'RE UPSETTING THE CHILDREN!  
		//  Allow Microsoft to settle this, with a splendid little burp from their MSDN archives...
		//		If you do not want to allow multiple selections in the ListView, 
		//		yet still want to offer the user a way for multiple items to be chosen, 
		//		you can display check boxes by setting the CheckBoxes property to true.
		//		The End.  Now no more fighting, you chowderbrains!
		//                return lvSelectedUnitsCheckboxes.MultiSelect;
		//				//return this._multiSelect;
		//            }
		//            set
		//            {
		//				//Removed. This setting does not affect checkboxes!
		//                //Replaced. That's not what it's for. And yes it can.
		//                // use MultiSelect instead.
		//                lvSelectedUnitsCheckboxes.MultiSelect = value;
		//				//this._multiSelect = value;
		//            }
		//        }

		//
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Blood Unit Search";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.Common.DlgSelectBloodUnits());
			this.RequiredFieldsLabel = false;
			//
			this.ttToolTip.SetToolTip(this.btnClearAntigens, Common.StrRes.Tooltips.UC005.DeselectAllSpecialTesting().ResString);
			this.ttToolTip.SetToolTip(this.btnClearABORh, Common.StrRes.Tooltips.UC005.DeselectAllABORh().ResString);
			this.ttToolTip.SetToolTip(this.btnClearProducts, Common.StrRes.Tooltips.UC005.DeselectAllProducts().ResString);
			//
			this.dtpExpAfter.CustomFormat = " ";//Common.VBECSDateTime.DateFormat;
			this.dtpExpBefore.CustomFormat = " ";//Common.VBECSDateTime.DateFormat;
			this.dtpRcvdAfter.CustomFormat = " ";//Common.VBECSDateTime.DateFormat;
			this.dtpRcvdBefore.CustomFormat = " ";//Common.VBECSDateTime.DateFormat;

			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpExpAfter.Value = _currentDate;
			this.dtpExpBefore.Value  = _currentDate;
			this.dtpRcvdAfter.Value = _currentDate;
			this.dtpRcvdBefore.Value = _currentDate;
		}

		//
		private bool VerifyMinColumnsInDataTable(System.Data.DataTable dt)
		{
			return Common.Utility.VerifyMinColumnsInDataTable(MINCOLUMNLIST.Split(','), dt);
		}

		#endregion

        #region Windows Form Designer generated code

        /// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DlgSelectBloodUnits));
            System.Windows.Forms.ListViewItem listViewItem1 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "WHOLE BLOOD"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem2 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "RED BLOOD CELLS"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem3 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "Washed RED BLOOD CELLS"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem4 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "Frozen RED BLOOD CELLS"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem5 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "Frozen Rejuvenated RED BLOOD CELLS"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem6 = new System.Windows.Forms.ListViewItem(new string[] {
            "ABO RH",
            "Pooled Pooled"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem7 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "A Pos"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem8 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "A Neg"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem9 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "B"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem10 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "B Pos"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem11 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "B Neg"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem12 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "AB"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem13 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "AB Pos"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem14 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "AB Neg"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem15 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "O Pos"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem16 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "O Neg"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            System.Windows.Forms.ListViewItem listViewItem17 = new System.Windows.Forms.ListViewItem(new string[] {
            "",
            "O"}, -1, System.Drawing.SystemColors.WindowText, System.Drawing.SystemColors.Window, new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0))));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpSearch = new System.Windows.Forms.GroupBox();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.dtpExpBefore = new System.Windows.Forms.DateTimePicker();
            this.cbExpBefore = new System.Windows.Forms.CheckBox();
            this.cbExpAfter = new System.Windows.Forms.CheckBox();
            this.dtpExpAfter = new System.Windows.Forms.DateTimePicker();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.dtpRcvdBefore = new System.Windows.Forms.DateTimePicker();
            this.cbRcvdBefore = new System.Windows.Forms.CheckBox();
            this.cbRcvdAfter = new System.Windows.Forms.CheckBox();
            this.dtpRcvdAfter = new System.Windows.Forms.DateTimePicker();
            this.grpProductType = new System.Windows.Forms.GroupBox();
            this.btnClearProducts = new System.Windows.Forms.Button();
            this.lvProductType = new System.Windows.Forms.ListView();
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpABORh = new System.Windows.Forms.GroupBox();
            this.btnClearABORh = new System.Windows.Forms.Button();
            this.lvABORh = new System.Windows.Forms.ListView();
            this.grpSpecial = new System.Windows.Forms.GroupBox();
            this.btnClearAntigens = new System.Windows.Forms.Button();
            this.txtAntigen = new System.Windows.Forms.TextBox();
            this.cbSickleCellScreen = new System.Windows.Forms.CheckBox();
            this.cbCMVNeg = new System.Windows.Forms.CheckBox();
            this.lstAntigens = new System.Windows.Forms.ListView();
            this.columnHeader8 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.lblRBCAntigen = new System.Windows.Forms.Label();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.colDonation = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colStatus = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colDateTimeReceived = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colProduct = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colCheckBox = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colUnitID = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colABORh = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colExpire = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpSelectedUnits = new System.Windows.Forms.GroupBox();
            this.pnlRight = new System.Windows.Forms.Panel();
            this.lvSelectedUnitsCheckboxes = new System.Windows.Forms.ListView();
            this.colCode = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colRestrictedFor = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpSearch.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.grpProductType.SuspendLayout();
            this.grpABORh.SuspendLayout();
            this.grpSpecial.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpSelectedUnits.SuspendLayout();
            this.pnlRight.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(728, 30);
            this.vbecsLogo1.TabIndex = 4;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 463);
            this.lblRequiredField.TabIndex = 6;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(568, 450);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 1;
            this.toolTip1.SetToolTip(this.btnOK, "Unit selection required.");
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(648, 450);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Cancel";
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "";
            this.columnHeader1.Width = 25;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "ABO RH";
            this.columnHeader2.Width = 79;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "";
            this.columnHeader3.Width = 25;
            // 
            // grpSearch
            // 
            this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSearch.Controls.Add(this.groupBox2);
            this.grpSearch.Controls.Add(this.groupBox1);
            this.grpSearch.Controls.Add(this.grpProductType);
            this.grpSearch.Controls.Add(this.grpABORh);
            this.grpSearch.Controls.Add(this.grpSpecial);
            this.grpSearch.Location = new System.Drawing.Point(60, 30);
            this.grpSearch.Name = "grpSearch";
            this.grpSearch.Size = new System.Drawing.Size(664, 176);
            this.grpSearch.TabIndex = 3;
            this.grpSearch.TabStop = false;
            this.grpSearch.Text = "Search Criteria";
            // 
            // groupBox2
            // 
            this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox2.Controls.Add(this.dtpExpBefore);
            this.groupBox2.Controls.Add(this.cbExpBefore);
            this.groupBox2.Controls.Add(this.cbExpAfter);
            this.groupBox2.Controls.Add(this.dtpExpAfter);
            this.groupBox2.Location = new System.Drawing.Point(516, 96);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(142, 72);
            this.groupBox2.TabIndex = 4;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Expiration Date";
            // 
            // dtpExpBefore
            // 
            this.dtpExpBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpExpBefore.Enabled = false;
            this.dtpExpBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpExpBefore.Location = new System.Drawing.Point(60, 20);
            this.dtpExpBefore.Name = "dtpExpBefore";
            this.dtpExpBefore.Size = new System.Drawing.Size(78, 20);
            this.dtpExpBefore.TabIndex = 1;
            this.dtpExpBefore.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
            this.dtpExpBefore.ValueChanged += new System.EventHandler(this.dtpExpBefore_ValueChanged);
            // 
            // cbExpBefore
            // 
            this.cbExpBefore.AccessibleDescription = "Before Expiration Date";
            this.cbExpBefore.AccessibleName = "Before Expiration Date";
            this.cbExpBefore.Location = new System.Drawing.Point(8, 20);
            this.cbExpBefore.Name = "cbExpBefore";
            this.cbExpBefore.Size = new System.Drawing.Size(60, 20);
            this.cbExpBefore.TabIndex = 0;
            this.cbExpBefore.Text = "B&efore";
            this.cbExpBefore.CheckedChanged += new System.EventHandler(this.cbExpBefore_CheckedChanged);
            // 
            // cbExpAfter
            // 
            this.cbExpAfter.AccessibleDescription = "After Expiration Date";
            this.cbExpAfter.AccessibleName = "After Expiration Date";
            this.cbExpAfter.Location = new System.Drawing.Point(8, 44);
            this.cbExpAfter.Name = "cbExpAfter";
            this.cbExpAfter.Size = new System.Drawing.Size(52, 20);
            this.cbExpAfter.TabIndex = 2;
            this.cbExpAfter.Text = "A&fter";
            this.cbExpAfter.CheckedChanged += new System.EventHandler(this.cbExpAfter_CheckedChanged);
            // 
            // dtpExpAfter
            // 
            this.dtpExpAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpExpAfter.Enabled = false;
            this.dtpExpAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpExpAfter.Location = new System.Drawing.Point(60, 44);
            this.dtpExpAfter.Name = "dtpExpAfter";
            this.dtpExpAfter.Size = new System.Drawing.Size(78, 20);
            this.dtpExpAfter.TabIndex = 3;
            this.dtpExpAfter.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
            this.dtpExpAfter.ValueChanged += new System.EventHandler(this.dtpExpAfter_ValueChanged);
            // 
            // groupBox1
            // 
            this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox1.Controls.Add(this.dtpRcvdBefore);
            this.groupBox1.Controls.Add(this.cbRcvdBefore);
            this.groupBox1.Controls.Add(this.cbRcvdAfter);
            this.groupBox1.Controls.Add(this.dtpRcvdAfter);
            this.groupBox1.Location = new System.Drawing.Point(516, 16);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(142, 72);
            this.groupBox1.TabIndex = 3;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Received Date";
            // 
            // dtpRcvdBefore
            // 
            this.dtpRcvdBefore.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpRcvdBefore.Enabled = false;
            this.dtpRcvdBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpRcvdBefore.Location = new System.Drawing.Point(60, 20);
            this.dtpRcvdBefore.Name = "dtpRcvdBefore";
            this.dtpRcvdBefore.Size = new System.Drawing.Size(78, 20);
            this.dtpRcvdBefore.TabIndex = 1;
            this.dtpRcvdBefore.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
            this.dtpRcvdBefore.ValueChanged += new System.EventHandler(this.dtpRcvdBefore_ValueChanged);
            // 
            // cbRcvdBefore
            // 
            this.cbRcvdBefore.AccessibleDescription = "Before Received Date";
            this.cbRcvdBefore.AccessibleName = "Before Received Date";
            this.cbRcvdBefore.Location = new System.Drawing.Point(8, 20);
            this.cbRcvdBefore.Name = "cbRcvdBefore";
            this.cbRcvdBefore.Size = new System.Drawing.Size(60, 20);
            this.cbRcvdBefore.TabIndex = 0;
            this.cbRcvdBefore.Text = "&Before";
            this.cbRcvdBefore.CheckedChanged += new System.EventHandler(this.cbRcvdBefore_CheckedChanged);
            // 
            // cbRcvdAfter
            // 
            this.cbRcvdAfter.AccessibleDescription = "After Recieved Date";
            this.cbRcvdAfter.AccessibleName = "After Recieved Date";
            this.cbRcvdAfter.Location = new System.Drawing.Point(8, 44);
            this.cbRcvdAfter.Name = "cbRcvdAfter";
            this.cbRcvdAfter.Size = new System.Drawing.Size(52, 20);
            this.cbRcvdAfter.TabIndex = 2;
            this.cbRcvdAfter.Text = "&After";
            this.cbRcvdAfter.CheckedChanged += new System.EventHandler(this.cbRcvdAfter_CheckedChanged);
            // 
            // dtpRcvdAfter
            // 
            this.dtpRcvdAfter.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpRcvdAfter.Enabled = false;
            this.dtpRcvdAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpRcvdAfter.Location = new System.Drawing.Point(60, 44);
            this.dtpRcvdAfter.Name = "dtpRcvdAfter";
            this.dtpRcvdAfter.Size = new System.Drawing.Size(78, 20);
            this.dtpRcvdAfter.TabIndex = 3;
            this.dtpRcvdAfter.Value = new System.DateTime(2002, 11, 6, 0, 0, 0, 0);
            this.dtpRcvdAfter.ValueChanged += new System.EventHandler(this.dtpRcvdAfter_ValueChanged);
            // 
            // grpProductType
            // 
            this.grpProductType.AccessibleDescription = "Product Type";
            this.grpProductType.AccessibleName = "Product Type";
            this.grpProductType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpProductType.Controls.Add(this.btnClearProducts);
            this.grpProductType.Controls.Add(this.lvProductType);
            this.grpProductType.Location = new System.Drawing.Point(8, 16);
            this.grpProductType.Name = "grpProductType";
            this.grpProductType.Size = new System.Drawing.Size(212, 152);
            this.grpProductType.TabIndex = 0;
            this.grpProductType.TabStop = false;
            this.grpProductType.Text = "Product Type";
            // 
            // btnClearProducts
            // 
            this.btnClearProducts.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClearProducts.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnClearProducts.Image = ((System.Drawing.Image)(resources.GetObject("btnClearProducts.Image")));
            this.btnClearProducts.Location = new System.Drawing.Point(188, 0);
            this.btnClearProducts.Name = "btnClearProducts";
            this.btnClearProducts.Size = new System.Drawing.Size(16, 16);
            this.btnClearProducts.TabIndex = 1;
            this.btnClearProducts.Click += new System.EventHandler(this.btnClearProducts_Click);
            // 
            // lvProductType
            // 
            this.lvProductType.AccessibleDescription = "Product Type";
            this.lvProductType.AccessibleName = "Product Type";
            this.lvProductType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvProductType.CheckBoxes = true;
            this.lvProductType.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader3,
            this.columnHeader4});
            this.lvProductType.FullRowSelect = true;
            this.lvProductType.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            listViewItem1.StateImageIndex = 0;
            listViewItem2.StateImageIndex = 0;
            listViewItem3.StateImageIndex = 0;
            listViewItem4.StateImageIndex = 0;
            listViewItem5.StateImageIndex = 0;
            this.lvProductType.Items.AddRange(new System.Windows.Forms.ListViewItem[] {
            listViewItem1,
            listViewItem2,
            listViewItem3,
            listViewItem4,
            listViewItem5});
            this.lvProductType.Location = new System.Drawing.Point(8, 16);
            this.lvProductType.Name = "lvProductType";
            this.lvProductType.Size = new System.Drawing.Size(196, 128);
            this.lvProductType.TabIndex = 0;
            this.lvProductType.UseCompatibleStateImageBehavior = false;
            this.lvProductType.View = System.Windows.Forms.View.Details;
            this.lvProductType.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvProductType_ItemCheck);
            this.lvProductType.SelectedIndexChanged += new System.EventHandler(this.lvProductType_SelectedIndexChanged);
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "Product Type";
            this.columnHeader4.Width = 150;
            // 
            // grpABORh
            // 
            this.grpABORh.AccessibleDescription = "ABO/Rh";
            this.grpABORh.AccessibleName = "ABO/Rh";
            this.grpABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpABORh.Controls.Add(this.btnClearABORh);
            this.grpABORh.Controls.Add(this.lvABORh);
            this.grpABORh.Location = new System.Drawing.Point(224, 16);
            this.grpABORh.Name = "grpABORh";
            this.grpABORh.Size = new System.Drawing.Size(141, 152);
            this.grpABORh.TabIndex = 1;
            this.grpABORh.TabStop = false;
            this.grpABORh.Text = "ABO/Rh";
            // 
            // btnClearABORh
            // 
            this.btnClearABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClearABORh.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnClearABORh.Image = ((System.Drawing.Image)(resources.GetObject("btnClearABORh.Image")));
            this.btnClearABORh.Location = new System.Drawing.Point(117, 0);
            this.btnClearABORh.Name = "btnClearABORh";
            this.btnClearABORh.Size = new System.Drawing.Size(16, 16);
            this.btnClearABORh.TabIndex = 1;
            this.btnClearABORh.Click += new System.EventHandler(this.btnClearABORh_Click);
            // 
            // lvABORh
            // 
            this.lvABORh.AccessibleDescription = "ABO/Rh";
            this.lvABORh.AccessibleName = "ABO/Rh";
            this.lvABORh.Alignment = System.Windows.Forms.ListViewAlignment.Left;
            this.lvABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvABORh.CheckBoxes = true;
            this.lvABORh.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2});
            this.lvABORh.FullRowSelect = true;
            this.lvABORh.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            listViewItem6.StateImageIndex = 0;
            listViewItem7.StateImageIndex = 0;
            listViewItem8.StateImageIndex = 0;
            listViewItem9.StateImageIndex = 0;
            listViewItem10.StateImageIndex = 0;
            listViewItem11.StateImageIndex = 0;
            listViewItem12.StateImageIndex = 0;
            listViewItem13.StateImageIndex = 0;
            listViewItem14.StateImageIndex = 0;
            listViewItem15.StateImageIndex = 0;
            listViewItem16.StateImageIndex = 0;
            listViewItem17.StateImageIndex = 0;
            this.lvABORh.Items.AddRange(new System.Windows.Forms.ListViewItem[] {
            listViewItem6,
            listViewItem7,
            listViewItem8,
            listViewItem9,
            listViewItem10,
            listViewItem11,
            listViewItem12,
            listViewItem13,
            listViewItem14,
            listViewItem15,
            listViewItem16,
            listViewItem17});
            this.lvABORh.Location = new System.Drawing.Point(8, 16);
            this.lvABORh.Name = "lvABORh";
            this.lvABORh.Size = new System.Drawing.Size(125, 128);
            this.lvABORh.TabIndex = 0;
            this.lvABORh.UseCompatibleStateImageBehavior = false;
            this.lvABORh.View = System.Windows.Forms.View.Details;
            this.lvABORh.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvABORh_ItemCheck);
            this.lvABORh.SelectedIndexChanged += new System.EventHandler(this.lvABORh_SelectedIndexChanged);
            // 
            // grpSpecial
            // 
            this.grpSpecial.AccessibleDescription = "Special Testing";
            this.grpSpecial.AccessibleName = "Special Testing";
            this.grpSpecial.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSpecial.Controls.Add(this.btnClearAntigens);
            this.grpSpecial.Controls.Add(this.txtAntigen);
            this.grpSpecial.Controls.Add(this.cbSickleCellScreen);
            this.grpSpecial.Controls.Add(this.cbCMVNeg);
            this.grpSpecial.Controls.Add(this.lstAntigens);
            this.grpSpecial.Controls.Add(this.lblRBCAntigen);
            this.grpSpecial.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpSpecial.Location = new System.Drawing.Point(368, 16);
            this.grpSpecial.Name = "grpSpecial";
            this.grpSpecial.Size = new System.Drawing.Size(144, 152);
            this.grpSpecial.TabIndex = 2;
            this.grpSpecial.TabStop = false;
            this.grpSpecial.Text = "Special Testing";
            // 
            // btnClearAntigens
            // 
            this.btnClearAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClearAntigens.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnClearAntigens.Image = ((System.Drawing.Image)(resources.GetObject("btnClearAntigens.Image")));
            this.btnClearAntigens.Location = new System.Drawing.Point(122, 0);
            this.btnClearAntigens.Name = "btnClearAntigens";
            this.btnClearAntigens.Size = new System.Drawing.Size(16, 16);
            this.btnClearAntigens.TabIndex = 5;
            this.btnClearAntigens.Click += new System.EventHandler(this.btnClearAntigens_Click);
            // 
            // txtAntigen
            // 
            this.txtAntigen.AccessibleDescription = "R B C Antigens Search ";
            this.txtAntigen.AccessibleName = "R B C Antigens Search ";
            this.txtAntigen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtAntigen.Location = new System.Drawing.Point(8, 80);
            this.txtAntigen.Name = "txtAntigen";
            this.txtAntigen.Size = new System.Drawing.Size(130, 20);
            this.txtAntigen.TabIndex = 3;
            this.txtAntigen.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtAntigen_KeyUp);
            // 
            // cbSickleCellScreen
            // 
            this.cbSickleCellScreen.AccessibleDescription = "Sickle Cell Negative";
            this.cbSickleCellScreen.AccessibleName = "Sickle Cell Negative";
            this.cbSickleCellScreen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbSickleCellScreen.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbSickleCellScreen.Location = new System.Drawing.Point(8, 44);
            this.cbSickleCellScreen.Name = "cbSickleCellScreen";
            this.cbSickleCellScreen.Size = new System.Drawing.Size(130, 16);
            this.cbSickleCellScreen.TabIndex = 1;
            this.cbSickleCellScreen.Text = "&Sickle Cell Negative";
            this.cbSickleCellScreen.CheckedChanged += new System.EventHandler(this.cbSickleCellScreen_CheckedChanged);
            // 
            // cbCMVNeg
            // 
            this.cbCMVNeg.AccessibleDescription = "C M V Negitive";
            this.cbCMVNeg.AccessibleName = "C M V Negitive";
            this.cbCMVNeg.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbCMVNeg.Location = new System.Drawing.Point(8, 20);
            this.cbCMVNeg.Name = "cbCMVNeg";
            this.cbCMVNeg.Size = new System.Drawing.Size(130, 20);
            this.cbCMVNeg.TabIndex = 0;
            this.cbCMVNeg.Text = "CM&V Negative";
            this.cbCMVNeg.CheckedChanged += new System.EventHandler(this.cbCMVNeg_CheckedChanged);
            // 
            // lstAntigens
            // 
            this.lstAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lstAntigens.CheckBoxes = true;
            this.lstAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader8,
            this.columnHeader6});
            this.lstAntigens.FullRowSelect = true;
            this.lstAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            this.lstAntigens.HideSelection = false;
            this.lstAntigens.Location = new System.Drawing.Point(8, 100);
            this.lstAntigens.MultiSelect = false;
            this.lstAntigens.Name = "lstAntigens";
            this.lstAntigens.Size = new System.Drawing.Size(130, 44);
            this.lstAntigens.TabIndex = 4;
            this.lstAntigens.UseCompatibleStateImageBehavior = false;
            this.lstAntigens.View = System.Windows.Forms.View.Details;
            this.lstAntigens.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lstAntigens_ItemCheck);
            this.lstAntigens.SelectedIndexChanged += new System.EventHandler(this.lstAntigens_SelectedIndexChanged);
            // 
            // columnHeader8
            // 
            this.columnHeader8.Text = "";
            this.columnHeader8.Width = 25;
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "RBC Antigens";
            this.columnHeader6.Width = 70;
            // 
            // lblRBCAntigen
            // 
            this.lblRBCAntigen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblRBCAntigen.Location = new System.Drawing.Point(8, 64);
            this.lblRBCAntigen.Name = "lblRBCAntigen";
            this.lblRBCAntigen.Size = new System.Drawing.Size(132, 16);
            this.lblRBCAntigen.TabIndex = 2;
            this.lblRBCAntigen.Text = "RBC Antigens";
            this.lblRBCAntigen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 30);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 414);
            this.grpImage.TabIndex = 5;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 38;
            this.pictureBox1.TabStop = false;
            // 
            // colDonation
            // 
            this.colDonation.Text = "Donation";
            this.colDonation.Width = 75;
            // 
            // colStatus
            // 
            this.colStatus.Text = "Status";
            // 
            // colDateTimeReceived
            // 
            this.colDateTimeReceived.Text = "Date Received";
            this.colDateTimeReceived.Width = 100;
            // 
            // colProduct
            // 
            this.colProduct.Text = "Product";
            this.colProduct.Width = 150;
            // 
            // colCheckBox
            // 
            this.colCheckBox.Text = "";
            this.colCheckBox.Width = 20;
            // 
            // colUnitID
            // 
            this.colUnitID.Text = "     Unit ID";
            this.colUnitID.Width = 100;
            // 
            // colABORh
            // 
            this.colABORh.Text = "ABO/Rh";
            this.colABORh.Width = 55;
            // 
            // colExpire
            // 
            this.colExpire.Text = "Expires";
            this.colExpire.Width = 70;
            // 
            // grpSelectedUnits
            // 
            this.grpSelectedUnits.AccessibleDescription = "Units withing Criteria";
            this.grpSelectedUnits.AccessibleName = "Units withing Criteria";
            this.grpSelectedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelectedUnits.Controls.Add(this.pnlRight);
            this.grpSelectedUnits.Location = new System.Drawing.Point(60, 210);
            this.grpSelectedUnits.Name = "grpSelectedUnits";
            this.grpSelectedUnits.Size = new System.Drawing.Size(664, 234);
            this.grpSelectedUnits.TabIndex = 0;
            this.grpSelectedUnits.TabStop = false;
            this.grpSelectedUnits.Text = "Units within Criteria";
            // 
            // pnlRight
            // 
            this.pnlRight.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlRight.Controls.Add(this.lvSelectedUnitsCheckboxes);
            this.pnlRight.Location = new System.Drawing.Point(4, 16);
            this.pnlRight.Name = "pnlRight";
            this.pnlRight.Size = new System.Drawing.Size(656, 212);
            this.pnlRight.TabIndex = 0;
            // 
            // lvSelectedUnitsCheckboxes
            // 
            this.lvSelectedUnitsCheckboxes.AccessibleDescription = "Units withing Criteria";
            this.lvSelectedUnitsCheckboxes.AccessibleName = "Units withing Criteria";
            this.lvSelectedUnitsCheckboxes.AllowColumnReorder = true;
            this.lvSelectedUnitsCheckboxes.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvSelectedUnitsCheckboxes.CheckBoxes = true;
            this.lvSelectedUnitsCheckboxes.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colCheckBox,
            this.colUnitID,
            this.colProduct,
            this.colCode,
            this.colABORh,
            this.colExpire,
            this.colDonation,
            this.colStatus,
            this.colRestrictedFor,
            this.colDateTimeReceived});
            this.lvSelectedUnitsCheckboxes.FullRowSelect = true;
            this.lvSelectedUnitsCheckboxes.Location = new System.Drawing.Point(4, 3);
            this.lvSelectedUnitsCheckboxes.MultiSelect = false;
            this.lvSelectedUnitsCheckboxes.Name = "lvSelectedUnitsCheckboxes";
            this.lvSelectedUnitsCheckboxes.Size = new System.Drawing.Size(648, 209);
            this.lvSelectedUnitsCheckboxes.TabIndex = 0;
            this.lvSelectedUnitsCheckboxes.UseCompatibleStateImageBehavior = false;
            this.lvSelectedUnitsCheckboxes.View = System.Windows.Forms.View.Details;
            this.lvSelectedUnitsCheckboxes.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSelectedUnitsCheckboxes_ColumnClick);
            this.lvSelectedUnitsCheckboxes.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSelectedUnitsCheckboxes_ItemCheck);
            this.lvSelectedUnitsCheckboxes.SelectedIndexChanged += new System.EventHandler(this.lvSelectedUnitsCheckboxes_SelectedIndexChanged);
            // 
            // colCode
            // 
            this.colCode.Text = "Code";
            this.colCode.Width = 40;
            // 
            // colRestrictedFor
            // 
            this.colRestrictedFor.Text = "Restricted For";
            this.colRestrictedFor.Width = 85;
            // 
            // DlgSelectBloodUnits
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(728, 477);
            this.Controls.Add(this.grpSelectedUnits);
            this.Controls.Add(this.grpSearch);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.hlphelpChm.SetHelpKeyword(this, "Select_Units.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MinimizeBox = false;
            this.MinimumSize = new System.Drawing.Size(736, 504);
            this.Name = "DlgSelectBloodUnits";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "VBECS - Select Blood Units";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgSelectBloodUnits_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.DlgSelectBloodUnits_Load);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpSearch, 0);
            this.Controls.SetChildIndex(this.grpSelectedUnits, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpSearch.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.groupBox1.ResumeLayout(false);
            this.grpProductType.ResumeLayout(false);
            this.grpABORh.ResumeLayout(false);
            this.grpSpecial.ResumeLayout(false);
            this.grpSpecial.PerformLayout();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpSelectedUnits.ResumeLayout(false);
            this.pnlRight.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
        #endregion


		private void btnClearProducts_Click(object sender, System.EventArgs e)
		{
			this._isDeselectAll = true;

			foreach(ListViewItem lvi in lvProductType.CheckedItems)
			{
				lvi.Checked = false;
			}

			this._isDeselectAll = false;
			this.LoadUnits();
		}

		private void btnClearABORh_Click(object sender, System.EventArgs e)
		{
			this._isDeselectAll = true;

			foreach(ListViewItem lvi in lvABORh.CheckedItems)
			{
				lvi.Checked = false;
			}

			this._isDeselectAll = false;
			this.LoadUnits();
		}

		/// <summary>
		///  **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectBloodUnits_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.toolTip1.GetToolTip(btnOK);
			}

			this.SpeakMessage( textToSpeak );		
		}

		private void lvProductType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 Compliance
			this.SpeakListViewWithCheckBox(lvProductType);
		}

		private void lvABORh_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 Compliance
			this.SpeakListViewWithCheckBox(lvABORh);
		}

		private void lstAntigens_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 Compliance
			this.SpeakListViewWithCheckBox(lstAntigens);
		}

		private void lvSelectedUnitsCheckboxes_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 Compliance
			this.SpeakListViewWithCheckBox(lvSelectedUnitsCheckboxes);
		}

		#region Properties

		/// <summary>
		/// Sets the VBECS Logobar text to the value given.
		/// </summary>
		public string LogoBarText
		{
			get 
			{
				return this.vbecsLogo1.Title;
			}
			set 
			{
				this.vbecsLogo1.Title = value;
			}
		}
		
		/// <summary>
		/// MaximumSelectedItems
		/// </summary>
		public int MaximumSelectedItems
		{
			get
			{
				return _maximumSelectedItems;
			}
			set
			{
				_maximumSelectedItems = value;
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/10/2003</CreationDate>
		///
		/// <summary>
		/// Allow or disallow more than one item to be selected.
		/// </summary>
		public bool MultiSelect
		{
			get 
			{
				return this._multiSelect;
			}
			set
			{
				this._multiSelect = value;
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/20/2002</CreationDate>
		///
		/// <summary>
		/// DataTable containing the units selected by the user.
		/// </summary>
		public System.Data.DataTable SelectedUnits
		{
			get
			{
				return _bloodUnitsSelected;
			}
		}

//		/// <summary>
//		/// Testing
//		/// </summary>
//		public System.Collections.ArrayList SelectedUnitGuids
//		{
//			get
//			{
//				return _selectedUnitGuids;
//			}
//		}


		/// <summary>
		/// Sets the title bar text to the value given.
		/// </summary>
		public string TitleBarText
		{
			get 
			{
				return this.Text;
			}
			set 
			{
				this.Text = value;
			}
		}

		//
		/// <summary>
		/// DataTable containing the Source DataTable to be searched.
		/// </summary>
		public System.Data.DataTable SourceUnitTable
		{
			get
			{
				return _bloodUnitsInitial;
			}
			set
			{
				if (VerifyMinColumnsInDataTable(value))
				{
					_bloodUnitsInitial = value;
					// BloodUnitGuid must be unique
					_bloodUnitsInitial.Columns[TABLE.BloodUnit.BloodUnitGuid].Unique = true;
					try
					{
						_unitFilter.InitialUnits = _bloodUnitsInitial;
					}
					catch (Exception)
					{
						MessageBox.Show(this,Common.StrRes.ValidMsg.UC005.InvalidSource().ResString,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
						this.Close();
					}
                    LoadUnits();
                    LoadProductTypes();
				}
				else
				{
					MessageBox.Show(this,Common.StrRes.ValidMsg.UC005.InvalidSourceCol().ResString,"Error",MessageBoxButtons.OK,MessageBoxIcon.Error);
					this.Close();
				}
			}
        }
		#endregion

	}

}
